/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/
package cnrg.itx.ds;

import java.util.*;

/**
 * This class is used to hold a record (of security database zone file) from the directory server.
 */
class AuthenticateRecord
{
	private String m_Key = null;
	private int m_AccessLevel = 0;
	
	private static final String HDR_KEY = "pin=";
	private static final String HDR_ACCESS = "access=";
	private static final String DELIMITER = ";";
	private static final int OFFSET_HDR_KEY = HDR_KEY.length();
	private static final int OFFSET_HDR_ACCESS = HDR_ACCESS.length();
							  
	/**
	 * Constructor from raw string format in directory database
	 * @param strAuthenticate string formatted as entry record in the directory database
	 */
	public AuthenticateRecord(String strAuthenticate) 
	{
		String field;
		StringTokenizer st = new StringTokenizer(strAuthenticate,DELIMITER);
		
		field = st.nextToken();
		m_Key = new String(field.substring(OFFSET_HDR_KEY));
		field = st.nextToken();
		m_AccessLevel = Integer.parseInt(field.substring(OFFSET_HDR_ACCESS));
	}

	/**
	 * Constructor from password and accesslevel
	 * @param pw Password object
	 * @param accessLevel access level (DirectoryService.USER_ACCESS_LEVEL, DirectoryService.SERVER_ACCESS_LEVEL, DirectoryService.ADM_ACCESS_LEVEL)
	 */
	public AuthenticateRecord(Password pw, int accessLevel) {
		m_Key = pw.toString();
		m_AccessLevel = accessLevel;
	}
	
	/**
	 * Convert into raw string format in directory database
	 * @return String formatted as entry record in the directory database
	 */
	public String toString() {
		return new String(HDR_KEY + m_Key + DELIMITER + HDR_ACCESS + m_AccessLevel);
	}

	/**
	 * Get access level
	 * @return the access level
	 */
	public int getAccessLevel(){
		return m_AccessLevel;
	}
	
	/**
	 * Get the password key
	 * @return the password key
	 */
	public String getKey(){
		return m_Key;
	}
}